#include "gengine.h"

#define SCREENW	640
#define SCREENH 480
#define COLORDEPTH 16
#define APPNAME "X" 

HWND hScreen;
HINSTANCE hInst;
BOOL bActive;

long FAR WINAPI WindowProc(HWND hWnd,UINT message, 
                           WPARAM wParam,LPARAM lParam );


int MsgBox( char *s )
{
	MessageBox( hScreen, s, APPNAME, MB_OK );
	return 0;
}

// ʾϢ
int FailMsg(char *s)
{
    MessageBox(hScreen,s,APPNAME,MB_OK);
    DestroyWindow(hScreen);
    return -1;
} 

// ʼ, DirectX
static BOOL doInit(HINSTANCE hInstance,int nCmdShow)
{
    WNDCLASS            wc;

    wc.style=          CS_HREDRAW|CS_VREDRAW;
    wc.lpfnWndProc=    WindowProc;
    wc.cbClsExtra=     0;
    wc.cbWndExtra=     0;
    wc.hInstance=      hInstance;
    wc.hIcon=          LoadIcon(hInstance,"WS_ICON");
    wc.hCursor=        NULL;//LoadCursor(,NULL);
    wc.hbrBackground=  NULL;
    wc.lpszMenuName=   NULL;
    wc.lpszClassName=  APPNAME;
    RegisterClass(&wc);
    
    hScreen=CreateWindowEx(
        0,
        APPNAME,
        APPNAME,
        WS_SYSMENU,
        0,
        0,
        GetSystemMetrics(SM_CXSCREEN),
        GetSystemMetrics(SM_CYSCREEN),
        NULL,
        NULL,
        hInstance,
        NULL );

    if(!hScreen)
        return false;

    ShowWindow(hScreen,nCmdShow);
    UpdateWindow(hScreen);

	hInst = hInstance;
	DebugInit();
	InitConfig();	//ļ
	ConfigSetFile( "diablo.cfg" );
	if( InitGraphicEngine( SCREENW, SCREENH, COLORDEPTH ) != 0 )
		return false;

	return true;
} 

// Ϣѭ
long FAR WINAPI WindowProc(HWND hWnd,UINT message, 
                           WPARAM wParam,LPARAM lParam )
{
	switch(message){
	case WM_ACTIVATEAPP:
		bActive = wParam;
		if( bActive ){
			RestoreDDraw();
		}
		DInputSync( bActive );
		break;

	case WM_CREATE:
		break;

	case WM_DESTROY:

		break;
	
	case WM_SETCURSOR:
		SetCursor( NULL );
		return TRUE;
		break;

	case WM_KEYDOWN:

		switch(wParam){
		case VK_ESCAPE:
			ConfigExit();
            DebugEnd(); 
			PostQuitMessage(0);
			break;
		}
		 break;

    }
    return DefWindowProc(hWnd,message,wParam,lParam);
} 

int WINAPI WinMain(HINSTANCE hInstance,HINSTANCE hPrevInstance,
                   LPSTR lpCmdLine,int nCmdShow)
{
    MSG         msg;

    if(!doInit(hInstance,nCmdShow))
		return false;

    while(1){
		if(PeekMessage(&msg,NULL,0,0,PM_NOREMOVE)){
            if(!GetMessage(&msg,NULL,0,0)){
				return msg.wParam;
			}
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
		else if(bActive) {
			if (testGraphicEngine()) {
				ExitGraphicEngine();
			    PostQuitMessage(0);
			}
		}
		else{
			WaitMessage();
		}
	}
} 
